using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/22/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>Used to stop the tab key in a datagrid from processing twice.</summary>

		#endregion

	public class KeyTrapTextBox : TextBox
	{
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		const int WM_KEYDOWN = 0x100;
		const int WM_KEYUP = 0x101;
		const int WM_CHAR = 0x0102; 
		private bool _bChanged = false;
		private bool _processAcross;

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/11/2003</CreationDate>
		/// <summary>
		/// KeyTrapTextBox constructor.
		/// </summary>
		public KeyTrapTextBox()
		{
			InitializeComponent();
		}

	
		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion

		#region Properties
		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/6/2003</CreationDate>
		/// <summary>
		/// Gets or sets whether the grid will be processed from left to right.  If this value is false
		/// the grid will be processed from top to bottom.
		/// </summary>
		public bool ProcessAcross
		{
			get
			{
				return _processAcross;
			}
			set 
			{
				_processAcross = value;
			}
		}
		#endregion

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/22/2003</CreationDate>
		/// <summary>
		///  This is used to stop the tab key in a datagrid from processing twice when the grid is being processed left to right.
		///  If the grid is processed fro top to bottem, the tab key is changed to the enter key.
		/// </summary>
		/// <param name="msg">ref</param>
		/// <returns></returns>
		public override bool PreProcessMessage(	ref Message msg )
		{
			Keys keyCode = (Keys)(int)msg.WParam & Keys.KeyCode;
			
			if (_processAcross)
			{
				if(msg.Msg == WM_KEYDOWN
					&& keyCode == Keys.Tab )
				{		
					return true;
				}
			}
			else
			{
				if(!_bChanged)
				{
					if(msg.Msg == WM_KEYDOWN
						&& keyCode == Keys.Tab )
					{		
						msg.WParam = (System.IntPtr) Keys.Enter;
						_bChanged = true;
						return false;
					}
				}
				else
				{
					_bChanged = false;
				}
			}

			return base.PreProcessMessage(ref msg);
		}
	}
}

